<?php
// ==================================================
//  FILE : sendToTelegram.php
//  Fungsi : Mengirim pesan pengunjung ke Telegram
//  Versi : Multi-user + Nama + Email
// ==================================================

// === KONFIGURASI BOT TELEGRAM ===
$botToken = "8449252581:AAE-mplDQPCKIlbD6iCzL4ZwY7zcgKkcJwU";       // Ganti dengan token bot Telegram Anda
$adminChatId = "8250132778";     // Ganti dengan chat ID Anda di Telegram

// === FOLDER PENYIMPANAN CHAT ===
$dataDir = __DIR__ . "/data/chats";
if (!file_exists($dataDir)) {
    mkdir($dataDir, 0777, true);
}

// === BACA DATA DARI JAVASCRIPT ===
$input = json_decode(file_get_contents("php://input"), true);
$name    = htmlspecialchars($input['name'] ?? 'Pengunjung');
$email   = htmlspecialchars($input['email'] ?? '-');
$message = htmlspecialchars($input['message'] ?? '');

if (!$message) {
    echo json_encode(['status' => 'error', 'message' => 'Pesan kosong']);
    exit;
}

// === CEK / BUAT SESSION PENGGUNA ===
if (isset($_COOKIE['session_chat'])) {
    $sessionId = $_COOKIE['session_chat'];
} else {
    $sessionId = 'sess_' . bin2hex(random_bytes(5));
    setcookie('session_chat', $sessionId, time() + 86400 * 30, '/');
}

// === SIMPAN CHAT SECARA LOKAL (JSON) ===
$file = "$dataDir/$sessionId.json";
$messages = [];

if (file_exists($file)) {
    $json = file_get_contents($file);
    $messages = json_decode($json, true);
    if (!is_array($messages)) $messages = [];
}

// Simpan pesan pengguna
$messages[] = [
    'from' => 'user',
    'message' => $message,
    'name' => $name,
    'email' => $email,
    'time' => date('Y-m-d H:i:s')
];

file_put_contents($file, json_encode($messages, JSON_PRETTY_PRINT));

// === KIRIM KE TELEGRAM ===
$text = "💬 *Pesan Baru dari Website*\n"
      . "👤 Nama: *{$name}*\n"
      . "📧 Email: {$email}\n"
      . "🆔 Session: `{$sessionId}`\n"
      . "💭 Pesan:\n_{$message}_\n\n"
      . "Balas dengan format:\n"
      . "`#{$sessionId} pesan_anda`";

$sendUrl = "https://api.telegram.org/bot{$botToken}/sendMessage";

$params = [
    'chat_id' => $adminChatId,
    'text' => $text,
    'parse_mode' => 'Markdown'
];

// Kirim ke Telegram
$ch = curl_init($sendUrl);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, $params);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
$response = curl_exec($ch);
curl_close($ch);

// === KIRIM RESPON KE JAVASCRIPT ===
echo json_encode([
    'status' => 'ok',
    'session' => $sessionId,
    'telegram_response' => $response
]);
?>

